package brn.sim.handler.gantt;

import brn.sim.data.gantt.ModeTraceEvent;
import brn.sim.data.gantt.Trace;
import jist.swans.misc.Event;
import jist.swans.mac.AbstractMac;

/**
 */
public class GanttMacEventHandler extends GanttEventHandler {

  // ////////////////////////////////////////////////
  // locals
  //
  protected ModeTraceEvent nodeTraceEvent         = new ModeTraceEvent();

  // ////////////////////////////////////////////////
  // initialization
  //

  public GanttMacEventHandler(Trace trace) {
    super(trace);
  }

  public void registerHandlers() {
    Event.addHandler(AbstractMac.MacModeChanged.class, new MacModeChangedHandler());

//    Event.addHandler(LinkTraceEvent.class, this);
  }

  protected class MacModeChangedHandler implements Event.Handler {
    public void handle(Event event) {
      AbstractMac.MacModeChanged ev = (AbstractMac.MacModeChanged) event;

      nodeTraceEvent.set(ev);
      handleTrace(nodeTraceEvent);
    }
  }

}
