package brn.sim.handler.gantt;

import brn.sim.data.gantt.Trace;
import brn.sim.data.gantt.ChannelTraceEvent;
import jist.swans.misc.Event;
import jist.swans.radio.AbstractRadio;

/**
 */
public class GanttRadioChannelEventHandler extends GanttEventHandler {

  // ////////////////////////////////////////////////
  // locals
  //
  protected ChannelTraceEvent channelTraceEvent         = new ChannelTraceEvent();

  // ////////////////////////////////////////////////
  // initialization
  //

  public GanttRadioChannelEventHandler(Trace trace) {
    super(trace);
  }

  public void registerHandlers() {
    Event.addHandler(AbstractRadio.RadioChannelStartSwitchEvent.class, new GanttRadioChannelEventHandler.RadioChannelChangedHandler());

//    Event.addHandler(LinkTraceEvent.class, this);
  }

  protected class RadioChannelChangedHandler implements Event.Handler {
    public void handle(Event event) {
      AbstractRadio.RadioChannelStartSwitchEvent ev = (AbstractRadio.RadioChannelStartSwitchEvent) event;

      channelTraceEvent.set(ev);
      handleTrace(channelTraceEvent);
    }
  }

}
