package brn.sim.handler.gantt;

import brn.sim.data.gantt.Trace;
import brn.sim.data.gantt.RadioModeTraceEvent;
import jist.swans.misc.Event;
import jist.swans.mac.AbstractMac;

/**
 */
public class GanttRadioModeEventHandler extends GanttEventHandler {

  // ////////////////////////////////////////////////
  // locals
  //
  protected RadioModeTraceEvent nodeTraceEvent         = new RadioModeTraceEvent();

  // ////////////////////////////////////////////////
  // initialization
  //

  public GanttRadioModeEventHandler(Trace trace) {
    super(trace);
  }

  public void registerHandlers() {
    Event.addHandler(AbstractMac.RadioModeChanged.class, new RadioModeChangedHandler());

//    Event.addHandler(LinkTraceEvent.class, this);
  }

  protected class RadioModeChangedHandler implements Event.Handler {
    public void handle(Event event) {
      AbstractMac.RadioModeChanged ev = (AbstractMac.RadioModeChanged) event;

      nodeTraceEvent.set(ev);
      handleTrace(nodeTraceEvent);
    }
  }
}
