package brn.sim.scenario.rca;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jist.swans.misc.Util;
import brn.sim.AbstractParams;
import brn.sim.builder.MacBuilder.MDcfParams;
import brn.sim.builder.RateBuilder.*;

public class MacRcaTest extends RcaSim {
  
  public static List getSimulationSuiteCustomRadio() {
    List ret = new ArrayList();
    RcaParams params = new RcaParams.SampleParams();
    params.setProtocolsUdpAodv();
    params.setCustomRadioParams();
    params.endTime = 12;
    ret.add(params);
    return ret;
  }
  
  public static List getSimMac80211e() {
    RcaParams params = new RcaParams.ConstParams();
    params.setMac80211eParams();
    params.setProtocolsUdpAodv();
    List ret = new ArrayList();
    ret.add(params);
    return ret;
  }
  
  public static List getSimAnnoRate() {
    RcaParams params = new RcaParams();
    SampleParams sample = new SampleParams();
    AnnoParams anno = new AnnoParams();
    anno.rateSelection = sample;
    MDcfParams mac = (MDcfParams)params.node.mac;
    mac.rateSelection = anno;
    params.setProtocolsUdpAodv();
    List ret = new ArrayList();
    ret.add(params);
    return ret;
  }

  /*
   * (non-Javadoc)
   * 
   * @see brn.sim.AbstractDriver#getSimulationSuite()
   */
  public List getSimulationSuite(String version) {
    List all = new ArrayList();
    all.addAll(getSimulationSuiteCustomRadio());
//    all.addAll(getSimMac80211e());
//    all.addAll(getSimAnnoRate());
    return all;
  }

  /*
   * (non-Javadoc)
   * 
   * @see brn.sim.AbstractDriver#runDistSim()
   */
  protected void runDistSim() throws Exception {
    // load properties from stdin
    Properties configuration = new Properties();
    configuration.load(System.in);

    String configFile = configuration.getProperty("driver.config");
    AbstractParams options = (AbstractParams) Util.readObject(configFile);
    if (log.isInfoEnabled())
      log.info(brn.swans.Strings.toString(options, "  "));
    // RcaParams options = RcaParams.defaultParams().setUdpAodvParams();

    options.db = true;
    options.dbJobId = Integer
        .valueOf(configuration.getProperty("simulationId")).intValue();
    options.dbDef = "jdbc:mysql://"
        + configuration.getProperty("definitions.host") + "/"
        + configuration.getProperty("definitions.database");
    options.dbRes = "jdbc:mysql://" + configuration.getProperty("results.host")
        + "/" + configuration.getProperty("results.database");
    options.dbUser = configuration.getProperty("results.username");
    options.dbPassword = configuration.getProperty("results.password");

    try {
      run(options);
    } catch (Throwable e) {
      e.printStackTrace();
      System.exit(3);
    }
  }

  /**
   * Runs a local test defined in derived classes.
   */
  protected void runLocal() {
    try {
      List ps = getSimulationSuite("");
      if (ps.size() <= 0) {
        System.out.println("No sim defined");
        return;
      }
      AbstractParams p = (AbstractParams) ps.get(0);
      System.out.println("Sim params: " + p);
      run(p);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * @param args
   * @throws Throwable
   */
  public static void main(String[] args) throws Throwable {
    MacRcaTest sim = new MacRcaTest();
    sim.run(args);
  }

}
