package brn.sim.scenario.rca;

import test.sim.scenario.mac.MacTestHandler;
import jist.swans.Node;
import jist.swans.trans.AbstractTrans;
import brn.distsim.ormapper.util.DbBinaryLoader;
import brn.sim.AbstractDriver;
import brn.sim.AbstractParams;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.Builder;
import brn.sim.builder.BuilderException;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.RouteBuilder;

public class RcaSim extends AbstractDriver {

	public MacTestHandler macTestHandler;

	// ////////////////////////////////////////////////
	// initialize
	//

	/**
	 * Construct a new test object.
	 */
	public RcaSim() {
		macTestHandler = new MacTestHandler();
	}

	// @override
	protected void installBuilders(final AbstractParams options) {
		super.installBuilders(options);
		builderProvider.addBuilder(new RouteBuilder.Dumb());
		builderProvider.addBuilder(new NetBuilder.IpMacTest());
	}

	// @override
  protected void installHandlers(final AbstractParams options) throws Exception {
		super.installHandlers(options);
		macTestHandler.registerHandlers();
	}

	protected Object load(DbBinaryLoader loader, int simulationId,
			String configPath) throws Exception {
		Object ret = loader.load(simulationId, configPath);
		if (null == ret) {
      throw new Error("Object with path " + configPath + " not found for id "
          + simulationId);
		}
		return ret;
	}

	protected Object load(DbBinaryLoader loader, int simulationId,
			String configPath, boolean error) throws Exception {
		Object ret = loader.load(simulationId, configPath);
		if (null == ret && error) {
      throw new Error("Object with path " + configPath + " not found for id "
          + simulationId);
		}
		return ret;
	}

	// protected void runFile(String fileName) {
	// try {
	// AbstractParams params = (AbstractParams) Util.readObject(fileName);
	// params.db = true;
	// params.dbRes = "jdbc:mysql://localhost:3306/simulation";
	// params.dbDef = "jdbc:mysql://localhost:3306/simulation";
	// run(params);
	// } catch (Throwable e) {
	// e.printStackTrace();
	// System.exit(1);
	// }
	// }

	/*
	 * (non-Javadoc)
	 *
	 * @see brn.sim.AbstractDriver#runLocal()
	 */
	// protected void runLocal() {
	// MacTestParams params = new MacTestParams();
	//
	// params.seed = 2;
	// params.nodes = 2;
	//
	// params.handlerRadioEx = false;
	// // params.handlerLinkQuality = true;
	// params.handlerRadioTimeBar = true;
	// params.db = true;
	// params.dbRes = "jdbc:mysql://localhost:3306/simulation";
	// params.dbDef = "jdbc:mysql://localhost:3306/simulation";
	//
	// try {
	// run(params);
	// } catch (Throwable e) {
	// e.printStackTrace();
	// System.exit(1);
	// }
	// }
	/*
	 * (non-Javadoc)
	 *
	 * @see brn.sim.AbstractDriver#setupApplication(brn.sim.AbstractParams, int,
	 *      jist.swans.Node)
	 */
	protected void setupApplication(AbstractParams opts, int nodeId, Node node)
			throws BuilderException {
		super.setupApplication(opts, nodeId, node);

		RcaParams params = (RcaParams) opts;

		// transport
		if (null != params.transParams) {
			Builder builder = builderProvider.getBuilder(params.transParams);
      AbstractTrans trans = (AbstractTrans) builder.build(params.transParams,
          node);
			builderProvider.addHookUp(builder, params.transParams, node, trans);
			node.addTransport(trans);
		}

		// app
		if (null != params.trafficParams) {
      // AppBuilder.UdpCaParams udpCa = (AppBuilder.UdpCaParams)
      // params.trafficParams.flowParams;
//			if (nodeId == 1) {
//				udpCa.serverAddr = node.getNet().getAddress();
//			} else {
//				udpCa.clientAddr = node.getNet().getAddress();
////				udpCa.flowId = nodeId;
//			}
//			params.trafficParams.flowParams = udpCa;
			Builder builder = builderProvider.getBuilder(params.trafficParams);
			Object ret = builder.build(params.trafficParams, node);
			builderProvider.addHookUp(builder, params.trafficParams, node, ret);
		}
	}

	public static void main(String[] args) throws Throwable {
		RcaSim test = new RcaSim();
		test.run(args);
	}

  protected void evalSimulationResults(String dbUrl, String dbUser,
      String dbPasswd, String driver, String version, String dbResUrl,
      String dbResUser, String dbResPasswd) throws Throwable {
    new Evaluator().evalSimulationResults(dbUrl, dbUser, dbPasswd, driver, version,
        dbResUrl, dbResUser, dbResPasswd);
  }
}
