package brn.sim.scenario.txdor;

import java.util.ArrayList;
import java.util.List;

import jist.swans.Constants;
import brn.sim.builder.RouteBuilder;
import brn.sim.builder.TransBuilder;
import brn.sim.builder.FlowBuilder.TcpParams;
import brn.sim.builder.FieldBuilder.FieldParams;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;
import brn.sim.builder.RadioBuilder.NoiseParams;
import brn.sim.builder.TrafficBuilder.RadialParams;

/**
 * @deprecated
 * @author kurth
 *
 */
public class MultiFlowTcp extends TxDOrSim {

  public static void main(String[] args) throws Throwable {
    MultiFlowTcp test = new MultiFlowTcp();
    test.run(args);
  }

  public static TxDOrParams getParams(int nodes, int seed, double stdDev,
      int csSize, int bitrate, int flows) {
    TxDOrParams params = (csSize != 1 ?
        TxDOrParams.defaultParams(new TxDOrParams()) :
          TxDOrParams.unicastParams(new TxDOrParams()));
    params.seed = seed;
    params.nodes = nodes;

    FieldParams field = (FieldParams) params.field;
    field.fieldX = 2000;
    field.fieldY = 2000;

    DistShadowingParams pathLoss = (DistShadowingParams) field.pathloss;
    pathLoss.stdDeviation = stdDev;

    NoiseParams radio = (NoiseParams) params.node.radio;
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
    radio.placement = Constants.PLACEMENT_RANDOM;
    radio.threshold = .8;
    radio.min_connectivity_betweenNodes = 2;

    // 50000 for DSR/ETT, 500 for TDiCOR
    // TODO ETX bounds for DSR/ETT
    params.setMetricAndBitRate(false, (csSize != 1 ? 500 : 50000),
        bitrate, Constants.BANDWIDTH_6Mbps);

    if (csSize != 1) {
      RouteBuilder.TxDORParams route = (RouteBuilder.TxDORParams) params.node.route;
      route.candidateSetSize = csSize;
    }

    // TODO time offset for start?
    TcpParams tcpParams = new TcpParams();
    tcpParams.start = 80000;
    TransBuilder.TcpParams tcp = (TransBuilder.TcpParams)params.transParams;
    tcpParams.tcpBytes = tcp.mss * 1000;

    RadialParams traffic = (RadialParams) params.trafficParams;
    traffic.startAngle = 0;
    traffic.flows = flows;
    traffic.flowParams = tcpParams;
    params.trafficParams = traffic;
    params.transParams = new TransBuilder.TcpParams();

    return params;
  }

  /**
   * Benchmark TDiCOR vs. DSR at 6/12 Mbps, multi-flow
   */
  public static List getSimulationSuite301() {
    List ret = new ArrayList();

    // TODO random Gateway traffic
    for (int nodes = 200; nodes <= 200; nodes *= 2) {
      for (int seed = 1; seed <= 20; seed++) {
        for (int stdDev = 4; stdDev <= 12; stdDev += 4) {
          for (int csSize = 1; csSize <= 4; csSize++) {
            for (int bitrate = Constants.BANDWIDTH_6Mbps; bitrate <= Constants.BANDWIDTH_12Mbps; bitrate *= 2) {
//              for (int gateway = 0; gateway <= 1; gateway ++) {
                for (int flows = 1; flows <= 3; flows += 1) {
                  TxDOrParams params = getParams(nodes, seed, stdDev, csSize,
                      bitrate, flows);

                  ret.add(params.setParamsBatch());
                }
//              }
            }
          }
        }
      }
    }

    return ret;
  }

}
