package brn.swans;

public class Constants {

  //////////////////////////////////////////////////
  // Radio-related constants
  //

  // radio noise types
  /** Radio noise additive with transmit diversity */
  public static final byte RADIO_NOISE_ADD_TXDIV = 3;
  /** Radio with empirical data */
  public static final byte RADIO_EMPIRICAL = 4;

  /** no diversity combining */
  public static final int RADIO_DIVERSITY_NONE = 0;
  /** diversity combining by stbc */
  public static final int RADIO_DIVERSITY_STBC = 1;
  /** non-coherent diversity combining */
  public static final int RADIO_DIVERSITY_NC = 2;
  /** selection combining (choose the strongest) */
  public static final int RADIO_DIVERSITY_SEL_MAX = 3;
  /** selection combining (choose the weakest) */
  public static final int RADIO_DIVERSITY_SEL_MIN = 4;

  public static final int BITERRORS_NONE = 0;
  public static final int BITERRORS_UNIFORM = 1;
  public static final int BITERRORS_ACCUMULATED = 2;
  public static final int BITERRORS_MASKED = 3;

  public static final int RADIO_CAPTURE_NONE = 0;
  public static final int RADIO_CAPTURE_MIM = 1;
  
  public static final int RADIO_CCA_MODE1 = 1;
  public static final int RADIO_CCA_MODE2 = 2;
  public static final int RADIO_CCA_MODE3 = 3;


  //////////////////////////////////////////////////
  // Mac-related constants
  //

  /** Mac 802.11 layer with transmit diversity. */
  public static final short MAC_802_11TXDIV = 8;

  /** simple nav impl without shortening */
  public static final int MAC_NAV_SIMPLE = 0;
  /** nav impl with shortening support */
  public static final int MAC_NAV_SHORTENING = 1;

  //////////////////////////////////////////////////
  // Network-related constants
  //

  /** ip network layer with notify support */
  public static final int NET_IPV4_NOTIFY = 0;

  /** network interface queue with iteration support */
  public static final int NET_QUEUE_ITERABLE = 2;


  //////////////////////////////////////////////////
  // Routing-related constants
  //

  /** protocol constant for brn dsr */
  public static final int NET_PROTOCOL_BRNDSR = 511;

  // dsr params
  /** reactive discovery */
  public static final int DISCOVERY_REACTIVE = 0;
  /** proactive discovery */
  public static final int DISCOVERY_PROACTIVE = 1;

  /** unicast forwarding */
  public static final int FORWARDING_UNICAST = 0;
  /** forwarding with passive ack */
  public static final int FORWARDING_PASSIVEACK = 1;
  /** forwarding with transmit diversity */
  public static final int FORWARDING_TXDOR = 2;
  /** forwarding with mcexor */
  public static final int FORWARDING_MCEXOR = 3;
  /** the default size of the candidate set for opportunistic protocols. */
  public static final int FORWARDING_DEFAULT_CANDIDATE_SET_SIZE = 3;

  /** indicates the last hop preference */
  public static final byte PREFERENCE_FNL         = 15;
  public static final byte PREFERENCE_MAX         = 14;
  public static final byte PREFERENCE_MIN         = 0;

  /** the default time for switching the rf channel */
  public static final long DEFAULT_DELAY_CHANNEL_SWITCH = 80000;

  public static final double DEFAULT_REF_NOISE_FACTOR   = 1.5;

  // metric params
  /** hop count metric */
  public static final int ROUTEMETRIC_HOPCOUNT = 1;
  /** etx metric */
  public static final int ROUTEMETRIC_ETX = 0;

  /** conservative candidate selection */
  public static final int TXDOR_CSSEL_CONSERVATIVE = 0;
  /** less conservative candidate selection */
  public static final int TXDOR_CSSEL_LESSCONS = 1;
  /** candidate selection with robust control rate */
  public static final int TXDOR_CSSEL_ROBCONRAT = 2;
  /** candidate selection based on ett metric */
  public static final int TXDOR_CSSEL_ETT = 3;
  
  public static final int TXDOR_CSSEL_EAX = 4;


  //////////////////////////////////////////////////
  // Transport-related constants
  //

}
