package brn.swans.app;

import jist.runtime.JistAPI;
import jist.runtime.JistAPI.Continuation;
import jist.swans.app.AppInterface;
import jist.swans.trans.TransInterface.TransUdpInterface;

/**
 * Udp application interface with congestion avoidance.
 *
 * @author kurth
 */
public interface UdpCaAppInterface extends AppInterface.UdpApp {

  /**
   * The server application informs the client that a packet arrived.
   * Therewith it is possible to limit the number of active packets within
   * the network.
   * @param packetId 
   */
  void packetArrived(int packetId);


  public static final class Dlg implements UdpCaAppInterface, JistAPI.Proxiable {
    UdpCaAppInterface dlg;

    public Dlg(UdpCaAppInterface dlg) {
      super();
      this.dlg = dlg;
    }

    public TransUdpInterface getUdpEntity() throws Continuation {
      return dlg.getUdpEntity();
    }

    public void packetArrived(int packetId) {
      dlg.packetArrived(packetId);
    }
  }
}
