package brn.swans.mac;

import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.runtime.JistAPI;
import brn.swans.misc.FeedbackMessageAnno;

/**
 * Receives RX/TX packet feedbacks from MAC.
 * author Zubow
 */
public interface MacRXTXFeedbackInterface {

  /**
   * TX feedback packet.
   *
   * @param msg     The sent message.
   * @param fAnno   The annotation of the feedbacked packet.
   */
  public void txfeedback(Message msg, FeedbackMessageAnno fAnno);

  /**
   * RX feedback packet.
   *
   * @param msg the received message
   * @param anno   The annotation of the received packet.
   */
  public void rxfeedback(Message msg, MessageAnno anno);

  public static final class Dlg implements MacRXTXFeedbackInterface, JistAPI.Proxiable {
    private MacRXTXFeedbackInterface macFeedback;

    public Dlg(MacRXTXFeedbackInterface macFeedback) {
      this.macFeedback = macFeedback;
    }

    public void txfeedback(Message msg, FeedbackMessageAnno fAnno) {
      macFeedback.txfeedback(msg, fAnno);
    }

    public void rxfeedback(Message msg, MessageAnno anno) {
      macFeedback.rxfeedback(msg, anno);
    }
  }
}
