package brn.swans.mac;

import java.util.List;

import jist.runtime.JistAPI;
import jist.swans.mac.MacAddress;
import jist.swans.mac.MacInterface;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;

public interface MacTxDORInterface extends MacInterface.MacDcf {

  /**
   * Schedules a packet for transmit diversity.
   *
   * @param msg the message to schedule
   * @param anno message annotations
   * @param candidates list of candidates
   * @param timeToSend the absolute point in time for transmission (w/o turnaround)
   * @param src the mac src address to set.
   * @param seqNo the mac seq no to set.
   * @param retry the mac retry bit to set.
   * @param idxFinalDst index of the final destination within the candidate set
   */
  void sendWithTxDiv(Message msg, MessageAnno anno, List candidates,
      long timeToSend, MacAddress src, short seqNo, boolean retry, byte idxFinalDst);

  /**
   * Remove out-dated information from forward buffer.
   */
  void cleanUpFwdBuffer();

  public static class Dlg implements JistAPI.Proxiable, MacTxDORInterface {
    private MacTxDORInterface dlg;

    public Dlg(MacTxDORInterface dlg) {
      super();
      this.dlg = dlg;
    }

    public void cfDone(boolean backoff, boolean delPacket) {
      dlg.cfDone(backoff, delPacket);
    }

    public void peek(Message msg, MessageAnno anno) {
      dlg.peek(msg, anno);
    }

    public void receive(Message msg, MessageAnno anno) {
      dlg.receive(msg, anno);
    }

    public void send(Message msg, MacAddress nextHop, MessageAnno anno) {
      dlg.send(msg, nextHop, anno);
    }

    public void setRadioMode(byte mode) {
      dlg.setRadioMode(mode);
    }

    public void startTimer(long delay, byte mode) {
      dlg.startTimer(delay, mode);
    }

    public void timeout(int timerId) {
      dlg.timeout(timerId);
    }

    public void sendWithTxDiv(Message msg, MessageAnno anno, List candidates, long timeToSend, MacAddress src, short seqNo, boolean retry, byte idxFinalDst) {
      dlg.sendWithTxDiv(msg, anno, candidates, timeToSend, src, seqNo, retry, idxFinalDst);
    }

    public void cleanUpFwdBuffer() {
      dlg.cleanUpFwdBuffer();
    }
  }
}
