package brn.swans.net;
import jist.runtime.JistAPI;
import jist.swans.misc.Mapper;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.net.NetAddress;
import jist.swans.net.NetIp;
import jist.swans.net.PacketLoss;

/**
 * Ip network layer with notifier
 * @author kurth
 */
public class NetIpNotify extends NetIp {

  //////////////////////////////////////////////////
  // locals
  //

  protected NetNotifyInterface netNotify;

  //////////////////////////////////////////////////
  // initialization
  //

  /**
   * @param addr
   * @param protocolMap
   * @param in
   * @param out
   */
  public NetIpNotify(NetAddress addr, Mapper protocolMap, PacketLoss in,
      PacketLoss out) {
    super(addr, protocolMap, in, out);
  }

  //////////////////////////////////////////////////
  // entity hookup
  //

  /**
   * @return the netNotify
   */
  public NetNotifyInterface getNetNotify() {
    return netNotify;
  }

  /**
   * @param netNotify the netNotify to set
   */
  public void setNetNotify(NetNotifyInterface netNotify) {
    if(!JistAPI.isEntity(netNotify))
      throw new IllegalArgumentException("expected entity");
    this.netNotify = netNotify;
  }

  //////////////////////////////////////////////////
  // send pump
  //

  /** {@inheritDoc} */
  public void endSend(Message msg, int interfaceId, MessageAnno anno) {
    super.endSend(msg, interfaceId, anno);

    NicInfo ni = nics[interfaceId];
    if(null != netNotify && ni.q.isEmpty() && !ni.busy) {
//      JistAPI.sleep(10 * Constants.MICRO_SECOND);
      netNotify.queueEmpty(interfaceId);
    }
  }
}
