package brn.swans.net;

import jist.runtime.JistAPI;

/**
 * Receives notifications from the network layer.
 *
 * @author kurth
 */
public interface NetNotifyInterface {

  /**
   * Inform about an empty queue.
   *
   * @param interfaceId the interface which queue ran empty.
   */
  void queueEmpty(int interfaceId);


  public static final class Dlg implements NetNotifyInterface, JistAPI.Proxiable {
    private NetNotifyInterface netNotify;

    public Dlg(NetNotifyInterface netNotify) {
      this.netNotify = netNotify;
    }

    /**
     * @see brn.swans.net.NetNotifyInterface#queueEmpty(int)
     */
    public void queueEmpty(int interfaceId) {
      netNotify.queueEmpty(interfaceId);
    }
  }
}
