package brn.swans.radio;

import jist.runtime.Main;
import jist.swans.misc.Util;
import brn.swans.radio.RadioNoiseAdditiveBER.RxEvent;
import brn.swans.radio.RadioNoiseAdditiveBER.StateAdditive;

/**
 * The caputure model to use with {@code RadioNoiseAdditiveBER}
 *
 * @author kurth
 */
public interface Capture {

  boolean doesCapture(StateAdditive state, RxEvent event);

  /**
   * No capture after synchronization to a preamble. Corresponds to Prism cards.
   */
  public static class None implements Capture {
    public boolean doesCapture(StateAdditive state, RxEvent event) {
      return false;
    }
  }

  /**
   * Class for message-in-message capture,
   * implemented e.g. by Atheros NICs.
   */
  public static class Mim implements Capture {
    /** threshold for capturing, the incoming signal has to be the specified
     * ratio stronger than the signal the receiver is synch'd to */
    private double captureThreshold = Util.fromDB(10);

    public Mim() {
    }
    
    public Mim(double captureThreshold) {
      this.captureThreshold = captureThreshold;
    }
    
    public boolean doesCapture(StateAdditive state, RxEvent event) {
      if (Main.ASSERT)
        Util.assertion(null != state.signalBuffer);

      if(event.getRxPower_mW() >= state.signalPower_mW * captureThreshold)
        return true;
      return false;
    }
  }

}
