package brn.swans.radio;

import jist.runtime.JistAPI;
import jist.runtime.JistAPI.Continuation;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.radio.RadioInterface;

/**
 * Radio Interface with preamble detection support.
 *
 * @author kurth
 */
public interface RadioExInterface extends RadioInterface{

  /**
   * The preamble is received and processed. Determine further radio operation
   * depending on the preamble could sucessfully received, or this was not
   * possible.
   * Called from {@link #receive(Message, Double, Long)}.
   * @param msg
   */
  void preambleReceived(Message msg, Long duration, RFChannel rfChannel, Object event);


  // Delegator
  public static final class Dlg implements RadioExInterface, JistAPI.Proxiable {
    RadioExInterface impl;

    public Dlg(RadioExInterface impl) {
      this.impl = impl;
    }

    public void transmit(Message msg, MessageAnno anno, long predelay,
        long duration, long postdelay) {
      impl.transmit(msg, anno, predelay, duration, postdelay);
    }

    public RadioInterface getProxy() {
      return (RadioExInterface) JistAPI.proxy(this, RadioExInterface.class);
    }

    public void endReceive(Message msg, Double power, RFChannel rfChannel,
        Object event) {
      impl.endReceive(msg, power, rfChannel, event);
    }

    public void endSetChannel(RFChannel channel) {
      impl.endSetChannel(channel);
    }

    public void endTransmit() {
      impl.endTransmit();
    }

    public RFChannel getChannel() throws Continuation {
      return impl.getChannel();
    }

    public void preambleReceived(Message msg, Long duration,
        RFChannel rfChannel, Object event) {
      impl.preambleReceived(msg, duration, rfChannel, event);
    }

    public void receive(Message msg, Double power, Long duration) {
      impl.receive(msg, power, duration);
    }

    public void setChannel(RFChannel channel, long delay) {
      impl.setChannel(channel, delay);
    }

    public void setSleepMode(boolean sleep) {
      impl.setSleepMode(sleep);
    }

    @SuppressWarnings("deprecation")
    public void transmit(Message msg, long delay, long duration,
        MessageAnno anno) {
      impl.transmit(msg, delay, duration, anno);
    }
  }
}
