package brn.swans.radio.biterrormodels;

import jist.swans.Constants;
import jist.swans.misc.Util;
import brn.swans.radio.TransmissionMode;
import brn.swans.radio.RadioNoiseAdditiveBER.ChunkErrorRates;


public class None extends BitErrorModel {

  @Override
  public int treatChunk(ChunkErrorRates rates, int bitPosition, long current, long previous, double snr) {
    TransmissionMode mode = rates.getMode();
    int dataBits = mode.getNumDataBits(current - previous);

    double csr = mode.getCachedSuccessRate(snr, dataBits);

    rates.updateChunk(bitPosition, csr, BitErrorMask.noErrors);
    return dataBits;
  }

  @Override
  protected BitErrorMask createErrors(int length, double snr, TransmissionMode mode) {
    Util.assertion(false);
    return null;
  }

  @Override
  public void postProcess(ChunkErrorRates rates) {
    double per = rates.getPer();
    if (0. < per && Constants.random.nextDouble() <= per)
      rates.updateChunk(0, 1., BitErrorMask.unspecifiedErrors);
  }

}
