package brn.swans.radio.biterrormodels;

import jist.swans.Constants;
import brn.swans.radio.TransmissionMode;
import brn.swans.radio.biterrormodels.BitErrorMask.SpecifiedErrors;

public class UniformDistribution extends BitErrorModel {

  @Override
  protected BitErrorMask createErrors(int length, double snr, TransmissionMode mode) {
    BitErrorMask mask = BitErrorMask.noErrors;
    double ber = mode.getBitErrorRate(snr);
    boolean bitErrors  = false;
    // poeses, poeses pyte!
    for (int pos = 0; pos < length && ber > .0; ++pos) {
      if (Constants.random.nextDouble() <= ber) {
        if (!bitErrors) {
          mask = new SpecifiedErrors(length);
          bitErrors = true;
        }
        mask.setError(pos);
      }
    }
    return mask;
  }

}
