package brn.swans.route;

import jist.runtime.JistAPI;
import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.net.NetAddress;
import jist.swans.net.NetMessage;
import jist.swans.net.NetMessage.Ip;

public interface RouteDsrTxDORInterface extends RouteDsrBrnInterface {

  public static final class Dlg implements RouteDsrTxDORInterface, JistAPI.Proxiable {
    RouteDsrTxDORInterface dlg;

    public Dlg(RouteDsrTxDORInterface dlg) {
      super();
      this.dlg = dlg;
    }

    public void peek(NetMessage msg, MacAddress lastHop, MessageAnno anno) {
      dlg.peek(msg, lastHop, anno);
    }

    public void receive(Message msg, NetAddress src, MacAddress lastHop, byte macId, NetAddress dst, byte priority, byte ttl, MessageAnno anno) {
      dlg.receive(msg, src, lastHop, macId, dst, priority, ttl, anno);
    }

    public void send(Ip msg, int interfaceId, MacAddress nextHop, MessageAnno anno) {
      dlg.send(msg, interfaceId, nextHop, anno);
    }

    public void send(NetMessage msg, MessageAnno anno) {
      dlg.send(msg, anno);
    }

    public void receive(NetMessage msg, MessageAnno anno, MacAddress lastHop,
        byte macId) {
      dlg.receive(msg, anno, lastHop, macId);
    }
  }

}
