package brn.swans.route;

import jist.runtime.JistAPI;
import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.net.NetAddress;
import jist.swans.net.NetMessage;
import jist.swans.net.NetMessage.Ip;
import jist.swans.route.RouteInterface;

public interface RouteTableInterface extends RouteInterface {

  void sendArpRequest(NetMessage.Ip ipMsg, MessageAnno anno, int device,
      NetAddress gateway, int retry);
  
  
  public static final class Dlg implements RouteTableInterface, JistAPI.Proxiable {
    RouteTableInterface dlg;

    public Dlg(RouteTableInterface dlg) {
      super();
      this.dlg = dlg;
    }
    public void peek(NetMessage msg, MacAddress lastHop, MessageAnno anno) {
      dlg.peek(msg, lastHop, anno);
    }
    public void receive(Message msg, NetAddress src, MacAddress lastHop,
        byte macId, NetAddress dst, byte priority, byte ttl, MessageAnno anno) {
      dlg.receive(msg, src, lastHop, macId, dst, priority, ttl, anno);
    }
    public void send(NetMessage msg, MessageAnno anno) {
      dlg.send(msg, anno);
    }
    public void sendArpRequest(Ip ipMsg, MessageAnno anno, int device,
        NetAddress gateway, int retry) {
      dlg.sendArpRequest(ipMsg, anno, device, gateway, retry);
    }
  }
  
}
