package brn.swans.route.metric;

import jist.swans.Node;
import jist.swans.mac.MacAddress;
import jist.swans.misc.Event;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.misc.MessageEvent;
import brn.swans.route.metric.LinkTable.LinkData;

public class AbstractRouteMetric {

  // ////////////////////////////////////////////////
  // events
  //

  public static class LinkMetricChangedEvent extends Event {
    public static final int CREATED = 0;
    public static final int UPDATED = 0;
    public static final int DELETED = 0;

    public int nodeId;
    public LinkTable linkTable;

    public LinkData linkInfo;
    public int operation;

    public LinkMetricChangedEvent(LinkTable linkTable, int nodeId) {
      this.nodeId = nodeId;
      this.linkTable = linkTable;
    }

    public void handle(LinkData linkInfo, int operation) {
      this.linkInfo = linkInfo;
      this.operation = operation;
      super.handle(nodeId);
    }
  }


  public static class LinkTableCreatedEvent extends Event {
    public LinkTable linkTable;

    public void handle(LinkTable linkTable, int nodeId) {
      this.linkTable = linkTable;
      super.handle(nodeId);
    }
  }


  public static class LinkProbeArrivedEvent extends MessageEvent {
    public MacAddress lastHop;

    public LinkProbeArrivedEvent(int nodeId) {
      super(nodeId);
    }

    public void handle(Message data, MessageAnno anno, MacAddress lastHop) {
      this.lastHop = lastHop;
      super.handle(data, anno);
    }
  }


  // ////////////////////////////////////////////////
  // constants
  //

  // ////////////////////////////////////////////////
  // locals
  //

  protected Node node;

  protected LinkTableCreatedEvent linkMetricCreatedEvent;

  protected LinkProbeArrivedEvent linkProbeArrivedEvent;


  // ////////////////////////////////////////////////
  // initialization
  //

  protected AbstractRouteMetric() {
    linkMetricCreatedEvent = new LinkTableCreatedEvent();
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  public Node getNode() {
    return node;
  }

  public void setNode(Node node) {
    this.node = node;
    linkProbeArrivedEvent = new LinkProbeArrivedEvent(node.getNodeId());
  }

}
