package brn.swans.route.metric;

import java.util.Map;

import jist.swans.mac.MacAddress;
import jist.swans.net.NetAddress;

public interface ArpTableInterface {

  /**
   * Inserts a mac-net-address binding into internal map.
   *
   * @param net the network address of the node
   * @param mac the coressponding mac address
   */
  void addArpEntry(NetAddress net, MacAddress mac);

  /**
   * Retrieves a mac-net-address binding from internal map.
   *
   * @param net the network address of the node
   * @return mac the coressponding mac address
   */
  MacAddress getArpEntry(NetAddress net);

  /**
   * Removes a mac-net-address binding from internal map.
   *
   * @param net the network address of the node
   */
  void removeArpEntry(NetAddress net);

  /**
   * Make a reverse arp request.
   *
   * @param lastHop mac address to query.
   * @return the net address belonging to the mac or null.
   */
  NetAddress getArpEntry(MacAddress lastHop);

  /**
   * Returns the whole arp table as map
   * @return the whole arp table as map
   */
  Map getArpTable();

}
