package brn.swans.route.metric;

import java.util.Collection;
import java.util.Hashtable;


/**
 * slow, legacy link table.
 *
 * TODO hashCode and equals
 *
 * @author kurth
 */
public class LinkTableSlow extends LinkTable {

  // ////////////////////////////////////////////////
  // locals
  //

  private Hashtable /* Object -> HostInfo */ hosts;

  private Hashtable /* ObjectPair -> LinkInfo */ links;


  // ////////////////////////////////////////////////
  // initialization
  //

  public LinkTableSlow() {
    this.hosts = new Hashtable();
    this.links = new Hashtable();
  }

  public LinkTableSlow(long tau) {
    super(tau);
    this.hosts = new Hashtable();
    this.links = new Hashtable();
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#setHostInfo(java.lang.Object, brn.swans.route.metric.LinkTable.HostInfo)
   */
  protected void setHostInfo(Object from, HostData nfrom) {
    hosts.put(from, nfrom);
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#getHostInfo(java.lang.Object)
   */
  public HostData getHostInfo(Object from) {
    HostData nfrom = (HostData) hosts.get(from);
    return nfrom;
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#getHosts()
   */
  public Collection getHosts() {
    return hosts.values();
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#setLinkInfo(java.lang.Object, java.lang.Object, brn.swans.route.metric.LinkTable.LinkInfo)
   */
  protected void setLinkInfo(Object from, Object to, LinkData lnfo) {
    links.put(new ObjectPair(from, to), lnfo);
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#getLinkInfo(java.lang.Object, java.lang.Object)
   */
  public LinkData getLinkInfo(Object from, Object to) {
    if (from == null || to == null)
      return null;

    LinkData nfo = (LinkData) links.get(new ObjectPair(from, to));
    return nfo;
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.route.metric.LinkTable#getLinks()
   */
  public Collection getLinks() {
    return this.links.values();
  }

}
