package brn.swans.route.metric;


import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.misc.Protocol;
import jist.swans.net.NetAddress;
import jist.swans.net.NetInterface;
import jist.runtime.JistAPI;

public interface RouteEtxEttMetricInterface extends Protocol, NetInterface.NetHandler {

  /**
   * LinkTable expiry timer.
   */
  void cleanUpLinkTable();

  /**
   * LinkStat expiry timer.
   */
  void cleanUpLinkStat();

  /**
   * LinkStat: sends out a new link probe packet
   */
  void runLinkStatSendHook();



  public final static class Dlg implements RouteEtxEttMetricInterface, JistAPI.Proxiable {
    RouteEtxEttMetricInterface impl;

    public Dlg(RouteEtxEttMetricInterface impl) {
      this.impl = impl;
    }

    public RouteEtxEttMetricInterface getProxy() {
      return (RouteEtxEttMetricInterface) JistAPI.proxy(this, RouteEtxEttMetricInterface.class);
    }

    public void cleanUpLinkStat() {
      impl.cleanUpLinkStat();
    }

    public void cleanUpLinkTable() {
      impl.cleanUpLinkTable();
    }

    public void runLinkStatSendHook() {
      impl.runLinkStatSendHook();
    }

    public void start() {
      impl.start();
    }

    public void receive(Message msg, NetAddress src, MacAddress lastHop, byte macId, NetAddress dst, byte priority, byte ttl, MessageAnno anno) {
      impl.receive(msg, src, lastHop, macId, dst, priority, ttl, anno);
    }

  }
}
