package brn.util;

import jist.swans.misc.Message;
import jist.swans.misc.MessageBytes;
import jist.swans.misc.Pickle;
import jist.swans.Constants;
import jist.swans.trans.TransUdp;

import java.util.List;
import java.util.Set;
import java.util.Iterator;

/**
 * Utility stuff.
 */
public class BrnUtil {

  public static String listToString(List lst) {
    StringBuffer str = new StringBuffer();
    for (int i = 0; i < lst.size(); i++) {
      str.append(lst.get(i));
      if (i < lst.size() -1)
        str.append(",");
    }
    return str.toString();
  }

  public static String setToString(Set set) {
    StringBuffer str = new StringBuffer();
    Iterator it = set.iterator();
    while(it.hasNext()) {
      str.append(it.next());
      if (it.hasNext())
        str.append(",");
    }
    return str.toString();
  }

  public static int extractFromMsgBytes(int header_type, Message content) {
    switch ( header_type ) {
      case Constants.NET_PROTOCOL_UDP:
        byte[] msgId = ((MessageBytes) content).getBytes();

        if (msgId.length == 0) {
          throw new RuntimeException("msgId is null; fix this.");
        }

        int pId = Pickle.arrayToInteger(msgId, TransUdp.UdpMessage.HEADER_SIZE);
        int flowId = Pickle.arrayToInteger(msgId, TransUdp.UdpMessage.HEADER_SIZE + 4);
        return flowId * 10000 + pId;
      case Constants.NET_PROTOCOL_TCP:
      default:
        throw new RuntimeException("Not yet implemented");
    }
  }

}
