package brn.util;

public class PooledDouble implements PoolableObject {

  public static class Pool extends ObjectPool.FixedSize {

    public Pool(int poolsize) {
      super(poolsize);
    }

    protected PoolableObject newObject() {
      return new PooledDouble();
    }
  }
  
//  private Pool defaultPool = new Pool(2000);
  
  private double value = 0;

  private PooledDouble() {
    super();
  }

  public void init() {
  }

  public void returned() {
    value = 0;
  }

  protected final void init(double value) {
    this.value = value;
  }

  public double getValue() {
    return value;
  }

}
