package brn.util;

/**
 * Simple Container class
 */
public class Tuple {
  private Object x;
  private Object y;
  private Object z;

  public Tuple(Object x, Object y) {
    this.x = x;
    this.y = y;
  }

  public Tuple(Object x, Object y, Object z) {
    this(x, y);
    this.z = z;
  }

  public Object getX() {
    return x;
  }

  public void setX(Object x) {
    this.x = x;
  }

  public Object getY() {
    return y;
  }

  public void setY(Object y) {
    this.y = y;
  }

  public Object getZ() {
    return z;
  }

  public void setZ(Object z) {
    this.z = z;
  }

  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    final Tuple tupel = (Tuple) o;

    if (x != null ? !x.equals(tupel.x) : tupel.x != null) return false;
    if (y != null ? !y.equals(tupel.y) : tupel.y != null) return false;
    if (z != null ? !z.equals(tupel.z) : tupel.z != null) return false;

    return true;
  }

  public int hashCode() {
    int result;
    result = (x != null ? x.hashCode() : 0);
    result = 29 * result + (y != null ? y.hashCode() : 0);
    result = 29 * result + (z != null ? z.hashCode() : 0);
    return result;
  }

  public String toString() {
    return "(" + x + ", " + y + ", " + z + ")";
  }
}
