package test.brn;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import brn.analysis.dump.BitErrorAggregator;
import brn.swans.radio.biterrormodels.BitErrorMasks;

public class TestBitErrors {

  public static void main(String[] args) throws IOException {
    BitErrorAggregator agg = new BitErrorAggregator("/home/alve/uni/Diplomarbeit/dump-20061220-3/tx-dump.pcap", false, true, false);
    File dir = new File("/home/alve/uni/Diplomarbeit/dump-20061220-3/");
    for (String file : dir.list()) {
      if (file.contains("tx")) continue;
      agg.analyze(dir.getAbsolutePath() + "/"+ file);
    }
    Set rates = new TreeSet();
    Set rssis = new TreeSet();
    Set lengths = new TreeSet();
    BitErrorMasks masks = agg.getErrorMasks();
    for(Object rate : masks.keySet()) {
      rates.add(rate);
      Map rssiMap = (Map)masks.get(rate);
      for (Object rssi : rssiMap.keySet()) {
        rssis.add(rssi);
        Map lengthMap = (Map)rssiMap.get(rssi);
        for (Object length : lengthMap.keySet()) {
          lengths.add(length);
        }
      }
    }
    System.out.println("rates:");
    for (Object rate : rates) {
      System.out.print(rate + " ");
    }
    System.out.println();
    System.out.println("rssis:");
    for (Object rssi : rssis) {
      System.out.print(rssi + " ");
    }
    System.out.println();
    System.out.println("lengths:");
    for (Object length : lengths) {
      System.out.print(length + " ");
    }
    System.out.println();
  }
}
