package test.brn;

import jist.swans.Constants;
import brn.sim.data.AbstractDiagramData;
import brn.sim.data.AveragedTimeLine;
import brn.sim.data.DiagramData;
import brn.sim.data.TimeLine;
import brn.sim.data.XplotSerializer;

public class TestDiagramDataRate {

  /**
   * @param args
   */
  public static void main(String[] args) throws Exception {
    int next = 70;
    double[] x = { 0.024275337, 0.943527681, 1.989142828, 2.993859601,
        3.956109577, 5.025275368, 6.00998465, 6.996388104, 7.95468832,
        9.032240766, 10.021617721, 10.922124797, 11.959710485, 14.008691922,
        15.100943939, 16.03012311, 18.069986194, 18.977348561, 19.985284718,
        21.065158845, 22.132424048, 24.212233836, 25.265561049, 26.229142853,
        29.323978324, 30.378088707, 34.372441056, 35.373190931, 36.403732524,
        37.494974865, 38.549830583, 39.590474785, 42.668731759, 43.711187549,
        44.654526717, 45.651719364, 46.65991077, 47.563712534, 48.531162705,
        49.520716765, 50.428460706, 51.419903272, 58.460778765, 63.375396888,
        64.370593605, 65.29911473, 66.295854045, 67.306169728, 68.331430824,
        69.28420459, 70.196639342, 72.109345343, 73.055317047, 75.147524836,
        76.103642975, 79.14940244, 80.207078002, 81.180876803, 82.104217,
        83.161156918, 84.077500364, 85.962920299, 88.978921919, 89.940449041,
        91.991031776, 92.983725939, 95.132633719, 96.172700288, 98.274485034,
        99.31312588, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0 };
    double[] y = { -76.22877836989903, -76.22877836989903, -74.64002484964574,
        -77.47023504330151, -76.45552157180545, -72.39673790325713,
        -80.15321781781027, -78.3999454822601, -79.15221100744836,
        -72.96781318388722, -80.53847065028587, -80.93920644016372,
        -77.69189475797747, -73.48172390556728, -76.10726825121154,
        -76.91736609789592, -77.38845177166694, -76.61375171083004,
        -78.88931305058877, -77.4389749616647, -77.21915370539983,
        -75.4656478838821, -71.28144145356559, -71.28144145356559,
        -75.73721115209847, -74.32243176224486, -81.2813356097143,
        -77.47082203173616, -79.3557603004137, -76.27035323671069,
        -79.10770304738332, -80.2260404845537, -77.50235307174428,
        -81.21105437994277, -79.98463285887252, -81.6314335488069,
        -76.08669427880481, -79.46753000168364, -80.30052230740793,
        -74.15068989157685, -75.64190483597014, -78.56157185359916,
        -77.79957169200786, -75.00757428360201, -75.00757428360201,
        -78.61835393873439, -73.73525803609571, -75.63933561861477,
        -81.28976795790497, -79.52024104018591, -79.5240982733127,
        -78.24364438709246, -78.48929912139172, -81.9956409444185,
        -81.9956409444185, -80.76067264120161, -78.18285323490069,
        -77.15986927518783, -77.15986927518783, -70.0737709575392,
        -70.0737709575392, -80.04479927478025, -79.50659885871177,
        -76.1322988668764, -80.5459414916515, -76.97957016490024,
        -76.98234853080733, -78.51314249589467, -78.34290295734402,
        -79.27459024990337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

    double sampleLen = 5;

    String[] path = new String[] {
        "SNR (ok packets)"};
    DiagramData rssiOk = new DiagramData(new TimeLine(path[path.length-1]),
        path, "time", "sec", "SNR", "dBm", AbstractDiagramData.MARK);
    TimeLine tlRssiOk = new TimeLine(path[0]);

    path = new String[] {
        "SNR (ok packets) avg'd"};
    DiagramData rssiOkRated = new DiagramData(
        new AveragedTimeLine("df", sampleLen, AveragedTimeLine.MODE_R, 1.),
        path, "time", "sec", "SNR", "dBm");
    rssiOk.addChain(rssiOkRated);

    for (int i = 0; i < next; i++) {
      rssiOk.addNextPoint(x[i], y[i]);
      tlRssiOk.add(x[i], y[i]);
    }

    AveragedTimeLine tlRssiOkRated =
      new AveragedTimeLine(tlRssiOk, (long)sampleLen*Constants.SECOND, 1, 1.);

    XplotSerializer seri =new XplotSerializer(rssiOk, "blue");
    seri.addPoints(tlRssiOk, "red");
    seri.saveToFile("rssiOk.xpl");

    seri =new XplotSerializer(rssiOkRated, "blue");
    seri.addPoints(tlRssiOkRated, "red");
    seri.saveToFile("rssiOkRated.xpl");
  }

}
