package test.brn.swans.misc;

import java.io.IOException;

import brn.sim.data.dump.WiresharkDump;

import jist.swans.mac.MacAddress;
import jist.swans.mac.MacDcfMessage;
import jist.swans.misc.MessageBytes;
import jist.swans.net.NetAddress;
import jist.swans.net.NetMessage;
import jist.swans.trans.TransUdp.UdpMessage;

public class WiresharkTest {

  /**
   * @param args
   * @throws IOException
   */
  public static void main(String[] args) throws IOException {

    WiresharkDump dump = new WiresharkDump("test.pcap",
        WiresharkDump.FAKE_DLT_IEEE802_11);

    MessageBytes b = new MessageBytes("Hello Wireshark!");

    UdpMessage udp = new UdpMessage(22, 33, b);

    NetAddress dstIp = new NetAddress(1);
    NetAddress srcIp = new NetAddress(2);
    NetMessage.Ip ip = new NetMessage.Ip(udp, srcIp, dstIp, (short)17, (byte)0, (byte)15);

    MacAddress dst = new MacAddress(1);
    MacAddress src = new MacAddress(2);
    int duration = 20000;
    MacDcfMessage.Data data = new MacDcfMessage.Data(dst, src, duration, ip);

    dump.dump(data, 0);
    dump.close();
  }

}
