package test.jist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import jist.runtime.JistAPI;

public class Hello2 {

  public interface Hello2If {
    void myEvent();
  }
  
  public Hello2If getProxy() {
    Object proxy = Proxy.newProxyInstance(Hello2.class.getClassLoader(), 
        new Class[] { Hello2If.class, JistAPI.Proxiable.class }, 
        new InvocationHandler() {
          public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(proxy, args);
          }});
    return (Hello2If)JistAPI.proxy(proxy, Hello2If.class);
  }
  
  public void myEvent() {
    JistAPI.sleep(1);
    getProxy().myEvent();
    System.out.println("hello world, t=" + JistAPI.getTime());
  }


  public static void main(String[] args) {
    System.out.println("simulation start");
    Hello2 h = new Hello2();
    h.getProxy().myEvent();
  }
}
