package test.jist;

import jist.runtime.JistAPI;

public interface TestInterface {

  void run();

  public final static class Delegate implements TestInterface, JistAPI.Proxiable  {

    private TestInterface impl;

    protected Delegate(TestInterface impl) {
      this.impl = impl;
    }
    
    public static TestInterface create(TestInterface impl) {
      return (TestInterface) JistAPI.proxy(new Delegate(impl), TestInterface.class);
    }

    public void run() {
      impl.run();
    }
  }
}
