package test.sim.scenario;

import brn.sim.scenario.mchannel.McExORParams;
import brn.sim.AbstractParams;
import brn.sim.builder.BuilderException;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;

import java.util.StringTokenizer;

import jist.swans.Constants;

/**
 * Tests the udp trhoughput of McExOR.
 */
public class EvalMcExORCSetBRateSim extends AbstractEvalMcExOR {

  protected String getFileName() {
    return "test_cs_rate"  + "_" + exponent + "_"
              + stdDeviation + "_" + coherenceTime + "_" + fading + "_" + constantDataBitRate / Constants.BANDWIDTH_1Mbps
              + "_" + constantCtrlBitRate / Constants.BANDWIDTH_1Mbps + ".dat";
  }

  public static void main(String[] args) {
    EvalMcExORCSetBRateSim test = new EvalMcExORCSetBRateSim();

    if (args.length < 1) {
      System.out.println("args required: seed KEY VALUE");
      return;
    } else {
      System.out.println("called with: " + args[0]);
    }

    try {
      StringTokenizer tk = new StringTokenizer(args[0]);

      /**
       * seed, key, idx, exponent, stdDeviation, coherenceTime, fading, dRate, cRate
       */
      McExORParams options = McExORParams.evalCandidateSetSelectionBitRateMChannel(
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()));

      test.run(options);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
