package test.sim.scenario;

import brn.sim.AbstractParams;
import brn.sim.scenario.mchannel.McExORParams;
import brn.sim.builder.*;
import brn.analysis.mcexor.McExOREval;
import brn.swans.app.UdpApplication;

import java.util.StringTokenizer;

import jist.swans.Node;
import jist.swans.trans.AbstractTrans;

/**
 * Tests the udp trhoughput of McExOR.
 */
public class EvalMcExORCSetSim extends AbstractEvalMcExOR {

  protected String getFileName() {
    return "test_cs"  + "_" + exponent + "_"
              + stdDeviation + "_" + coherenceTime + "_" + fading + ".dat";
  }

  public static void main(String[] args) {
    EvalMcExORCSetSim test = new EvalMcExORCSetSim();

    if (args.length < 1) {
      System.out.println("args required: seed KEY VALUE");
      return;
    }

    try {
      StringTokenizer tk = new StringTokenizer(args[0]);

      McExORParams options = McExORParams.evalCandidateSetSelection(
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()));

      test.run(options);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
