package test.sim.scenario;

import brn.sim.AbstractDriver;
import brn.sim.AbstractParams;
import brn.sim.handler.TimeBarRadioChannelHandler;
import brn.sim.handler.LinkQualityHandler;
import brn.sim.builder.*;
import brn.sim.scenario.mchannel.McExORParams;
import brn.analysis.mcexor.McExOREval;
import brn.analysis.mcexor.TestConstants;
import brn.analysis.mcexor.ImgCandidateSet;
import brn.swans.app.UdpApplication;
import test.sim.handler.McExORTestEventHandler;

import java.util.List;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.io.File;
import java.io.FileWriter;

import jist.runtime.JistAPI;
import jist.swans.Node;
import jist.swans.trans.AbstractTrans;

/**
 * Evaluates the candidate set selection in case of multiple RF channels.
 */
public class EvalMultiChannelCSetSim extends AbstractEvalMcExOR {

  protected String getFileName() {
    return "test_mch_cs"  + "_" + exponent + "_"
              + stdDeviation + "_" + coherenceTime + "_" + fading + ".dat";
  }

  public static void main(String[] args) {
    EvalMultiChannelCSetSim test = new EvalMultiChannelCSetSim();

    if (args.length < 1) {
      System.out.println("args required: seed KEY VALUE");
      return;
    }

    try {
      StringTokenizer tk = new StringTokenizer(args[0]);

      McExORParams options = McExORParams.evalMultiChannelCandidateSetSelection(
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()), new Integer(tk.nextToken()), new Integer(tk.nextToken()),
          new Integer(tk.nextToken()));

      test.run(options);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
