package test.sim.scenario;

import jist.swans.Constants;
import jist.swans.Node;
import jist.swans.misc.MessageAnno;
import jist.swans.net.NetAddress;
import jist.swans.net.NetIp;
import jist.swans.trans.TransUdp;
import brn.sim.AbstractDriver;
import brn.sim.AbstractParams;
import brn.sim.DeprecatedBasicParams;
import brn.sim.builder.BuilderException;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;
import brn.sim.builder.MetricBuilder;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.PathLossBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RouteBuilder;
import brn.swans.app.UdpApplication;


public class Mac802_11e1NodeSendingTest3 extends AbstractDriver {
  /** logger for mac events. */

  protected void setupApplication(AbstractParams opts, int nodeId, Node node) throws BuilderException {
    super.setupApplication(opts, nodeId, node);

//    DsrParams params = (DsrParams)opts;

    int txRate = 500;
    int txRate2 = 500;
    long start = 15 * Constants.SECOND;
    long end = start + 20 * Constants.SECOND + 500 * Constants.MILLI_SECOND;
    long start2 = start + 1 * Constants.SECOND;
    long end2 = start2 + 20 * Constants.SECOND + 500 * Constants.MILLI_SECOND;
    final int txPort = 9000;
    final int txPort2 = 9010;

    final NetIp net = (NetIp)node.getNet();


    TransUdp udp = new TransUdp();
    
    UdpApplication app11 = null;

    byte[] content = new byte[1460];
    if (1 == nodeId) {
      MessageAnno anno = new MessageAnno();
      anno.put(MessageAnno.ANNO_RTG_FLOWID, new Integer(0));
      app11 = new UdpApplication(net.getAddress(), txPort,
          new NetAddress(opts.nodes), txPort, start, end, txRate, Constants.NET_PRIORITY_D_VIDEO,
          content, anno);
      
     
    } else {
      app11 = new UdpApplication(net.getAddress(), txPort, start, end);

    }

    udp.setNetEntity(net.getProxy());
    net.setProtocolHandler(Constants.NET_PROTOCOL_UDP, udp.getProxy());
    app11.setUdpEntity(udp.getProxy());

    node.addTransport(udp);
    node.addApplication(app11);

    app11.getProxy().run();
  }

  public static void main(String[] args) {
    Mac802_11e1NodeSendingTest3 test = new Mac802_11e1NodeSendingTest3();

    if (args.length < 1) {
      test.showUsage();
      return;
    }

    try {
    DeprecatedBasicParams params = new DeprecatedBasicParams();

    // set parameters
    params.endTime = 100;
    params.seed = 0;
    params.nodes = 3;
    params.assertion = true;
    params.handlerRadio = true;
    params.handlerRadioEx = true;
    params.handlerRadioTimeBar = true;
    params.handlerTXOP = true;
    params.dumpRadio = "dsr.tr";
    params.dumpFieldNam = "dsr.nam";
    params.dumpNet = true;
    params.seed = 2;
    params.handlerMacTimeBar = true;
    params.handlerFlow = true;
    params.handlerForwardGraph = true;

    FieldBuilder.FieldParams field = new FieldBuilder.FieldParams();
    field.fieldX = 300;
    field.fieldY = 100;
    field.pathloss = new PathLossBuilder.FreeSpaceParams();
//    field.exponent = 2.7;
//    field.stdDeviation = 4.;
    field.spatial_mode = Constants.SPATIAL_LINEAR;
    params.field = field;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveParams();
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
    radio.placement = Constants.PLACEMENT_POISSON;
    radio.placementOpts = "0.5x0.5x30x18";
    radio.useAnnos = true;
    params.node.radio = radio;

    MacBuilder.M802_11eParams mac = new MacBuilder.M802_11eParams();
    mac.useAnnos = radio.useAnnos;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    NetBuilder.IpParams net = new NetBuilder.IpParams();
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE, Constants.NET_PROTOCOL_MCEXOR,
        Constants.NET_PROTOCOL_FLOODING };
    params.node.net = net;

    RouteBuilder.BrnDsrParams route = new RouteBuilder.BrnDsrParams();
    route.protocol = Constants.NET_PROTOCOL_MCEXOR;
    route.forwarding = brn.swans.Constants.FORWARDING_UNICAST;
    route.discovery = brn.swans.Constants.DISCOVERY_PROACTIVE;
    route.floodintOffset = 50000;
    route.floodingPeriod = 10000;
    route.floodingMax = 0;
    params.node.route = route;

    MetricBuilder.EtxParams metric = new MetricBuilder.EtxParams();
//    metric.rates = new int[] { 22 };
    metric.probes = new int[] { Constants.BANDWIDTH_DEFAULT, 1000 };
    metric.period = 1000;
    metric.tau = 30000;
    metric.globalLinkTable = true;
    route.metric = metric;

    test.run(params);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

}
