package test.sim.scenario;

import jist.swans.Constants;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RouteBuilder;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;
import brn.sim.scenario.txdor.TxDOrParams;
import brn.sim.scenario.txdor.TxDOrSim;

public class TestAodv {

  public static void main(String[] args) {
    TxDOrParams params =
      (TxDOrParams) TestParamBuilder.build(TxDOrParams.class);
    TxDOrSim test = new TxDOrSim();

    params.db = false;
    params.file = false;

    params.handlerRadio = true;
    params.handlerMac = true;
    params.handlerNet = true;
    params.handlerRoute = true;
    params.handlerFlow = true;
    params.handlerForwardGraph = true;
//    params.handlerLinkQuality = true;
    params.handlerLinkQuality = false;
    params.handlerLinkTable = true;
    params.handlerRadioTimeBar = true;
    params.handlerMacTimeBar = true;

    params.dumpRadio = "txdor.tr";
    params.dumpMac = true;
    params.dumpNet = true;
    params.dumpFieldNam = null;//"txdor-field.nam";
    params.dumpRadioNam = null;//"txdor-radio.nam";
    params.dumpMacNam = "txdor-mac.nam";
    params.dumpNetNam = "txdor-net.nam";

    // set parameters
    params.endTime = 130;
    params.seed = 2;
    params.nodes = 12;
    params.assertion = true;

    DistShadowingParams pathLoss = new DistShadowingParams();
    pathLoss.exponent = 2.7;
    pathLoss.stdDeviation = 4.;
    pathLoss.coherenceTime = 0 * Constants.SECOND;

    FieldBuilder.FieldParams field = new FieldBuilder.FieldParams();
    field.fieldX = 200;
    field.fieldY = 100;
    field.pathloss = pathLoss;
    field.spatial_mode = Constants.SPATIAL_LINEAR;
    params.field = field;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveParams();
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
//  params.placement = Constants.PLACEMENT_MANUAL;
//  params.placementOpts = "0x10 : 100x0 : 100x20 : 200x10";
    radio.placement = Constants.PLACEMENT_GRID;
    radio.placementOpts = "4x3";
    radio.useAnnos = false;
    radio.radioType = Constants.MAC_802_11b;
    params.node.radio = radio;

    MacBuilder.M802_11Params mac = new MacBuilder.M802_11Params();
    mac.useAnnos = radio.useAnnos;
//    mac.macType = radio.radioType;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    NetBuilder.IpParams net = new NetBuilder.IpNotifyParams();
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE, Constants.NET_PROTOCOL_AODV,
        Constants.NET_PROTOCOL_FLOODING };
    params.node.net = net;

    RouteBuilder.AodvParams route = new RouteBuilder.AodvParams();
    route.protocol = Constants.NET_PROTOCOL_AODV;
    route.aodvHelloInterval = 20;
    route.useAnnos = mac.useAnnos;
    params.node.route = route;

    params.trafficParams.flowParams.start = 80000;
    ((FlowBuilder.SaturatingUdpParams)params.trafficParams.flowParams).end = 95000;
    ((FlowBuilder.SaturatingUdpParams)params.trafficParams.flowParams).useAnnos = false;

    try {
      test.run(params);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }

}
