package test.sim.scenario;

import jist.swans.Constants;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;
import brn.sim.builder.MetricBuilder;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RouteBuilder;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;
import brn.sim.scenario.txdor.TxDOrParams;
import brn.sim.scenario.txdor.TxDOrSim;

public class TestBrnDsrSim {

  protected static TxDOrParams defaultParams() {
    TxDOrParams params = new TxDOrParams();

    params.db = false;
    params.dbRes = "jdbc:mysql://localhost:3306/simulation";
    params.dbDef = "jdbc:mysql://localhost:3306/simulation";
    params.file = false;
    params.directory = "/tmp/sim";

    params.handlerRadio = true;
    params.handlerMac = true;
    params.handlerNet = true;
    params.handlerRoute = true;
    params.handlerFlow = true;
    params.handlerForwardGraph = true;
    params.handlerLinkQuality = true;
    params.handlerLinkTable = true;
    params.handlerRadioTimeBar = true;
    params.handlerMacTimeBar = true;

    params.dumpRadio = null;//"txdor.tr";
    params.dumpMac = false;
    params.dumpNet = false;
    params.dumpFieldNam = null;//"txdor-field.nam";
    params.dumpRadioNam = null;//"txdor-radio.nam";
    params.dumpMacNam = null;//"txdor-mac.nam";
    params.dumpNetNam = null;//"txdor-net.nam";

    // set parameters
    params.endTime = 130;
    params.seed = 2;
    params.nodes = 12;
    params.assertion = true;

    DistShadowingParams pathLoss = new DistShadowingParams();
    pathLoss.exponent = 2.7;
    pathLoss.stdDeviation = 4.;
    pathLoss.coherenceTime = 0 * Constants.SECOND;

    FieldBuilder.FieldParams field = new FieldBuilder.FieldParams();
    field.fieldX = 200;
    field.fieldY = 100;
    field.pathloss = pathLoss;
    field.spatial_mode = Constants.SPATIAL_LINEAR;
    params.field = field;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveParams();
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
//  params.placement = Constants.PLACEMENT_MANUAL;
//  params.placementOpts = "0x10 : 100x0 : 100x20 : 200x10";
    radio.placement = Constants.PLACEMENT_GRID;
    radio.placementOpts = "4x3";
    radio.useAnnos = true;
    radio.radioType = Constants.MAC_802_11b;
    params.node.radio = radio;

    MacBuilder.M802_11Params mac = new MacBuilder.M802_11Params();
    mac.useAnnos = radio.useAnnos;
//    mac.macType = radio.radioType;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    NetBuilder.IpParams net = new NetBuilder.IpNotifyParams();
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE, Constants.NET_PROTOCOL_MCEXOR,
        Constants.NET_PROTOCOL_FLOODING };
    params.node.net = net;

    RouteBuilder.BrnDsrParams route = new RouteBuilder.BrnDsrParams();
    route.protocol = Constants.NET_PROTOCOL_MCEXOR;
    route.forwarding = brn.swans.Constants.FORWARDING_UNICAST;
    route.discovery = brn.swans.Constants.DISCOVERY_PROACTIVE;
    route.floodintOffset = 50000;
    route.floodingPeriod = 10000;
    route.floodingMax = 0;
    params.node.route = route;

    MetricBuilder.EtxParams metric = new MetricBuilder.EtxParams();
    metric.period = 1000;
    metric.tau = 30000;
    metric.probes = new int[] {Constants.BANDWIDTH_1Mbps, 1000};
    metric.numberOfChannels = field.channelNumber;
    metric.globalLinkTable = true;
    route.metric = metric;

    params.trafficParams.flowParams.start = 80000;
    ((FlowBuilder.SaturatingUdpParams)params.trafficParams.flowParams).end = 95000;
    return params;
  }


  public static void main(String[] args) {
    TxDOrSim test = new TxDOrSim();

    try {
      test.run(defaultParams());
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }

}
