package test.sim.scenario;

import brn.sim.AbstractParams;

public class TestParamBuilder {

  /**
   * Creates the specified params and sets all test related properties on it.
   *
   * @param paramClass the param class to create
   * @return an instance of the given class with test related params set.
   */
  public static AbstractParams build(Class paramClass) {
    AbstractParams params;
    try {
      params = (AbstractParams) paramClass.newInstance();
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }

    // set parameters
    params.dumpRadio = null;//"txdor.tr";
    params.dumpMac = false;
    params.dumpNet = false;

    // no javis
    params.dumpFieldNam = null;
    params.dumpNetNam = null;
    params.dumpMacNam = null;
    params.dumpRadioNam = null;

    params.gui = false;
    params.db = false;
    params.file = false;
    params.assertion = true;

    return params;
  }
}
