package test.sim.scenario;

import java.util.Arrays;

import test.sim.scenario.mac.MacTest;
import test.sim.scenario.mac.MacTestParams;

public class TestRca {

	public static void main(String[] args) throws Exception {
		System.out.println(Arrays.toString(args));
		
		MacTestParams params = (MacTestParams) TestParamBuilder
				.build(MacTestParams.class);

		/* gui on/off */
		params.gui = true;
		/* db stuff */
		params.db = true;

		params.txTimes = null; // ignore the tx times for now

		if (args.length < 1) {
			// use Constant rate
			testConstant(params);
		} else if (args[0].equals("arf")) {
			testArf(params);
		} else if (args[0].equals("aarf")) {
			testAarf(params);
		} else if (args[0].equals("sample")) {
			testSample(params);
    } else if (args[0].equals("amrr")) {
      testAmrr(params);
    }

	}

	private static void testConstant(MacTestParams params) throws Exception {
		MacTest test = new MacTest();
		test.run(params);
		test.runRcaTest((MacTestParams) params);
	}

	private static void testArf(MacTestParams params) throws Exception {
		params.setArfParams();
		MacTest test = new MacTest();
		test.run(params);
		test.runRcaTest((MacTestParams) params);
	}

	private static void testAarf(MacTestParams params) throws Exception {
		params.setAarfParams();
		MacTest test = new MacTest();
		test.run(params);
		test.runRcaTest((MacTestParams) params);
	}
	
	private static void testSample(MacTestParams params) throws Exception {
		params.setSampleParams();
		MacTest test = new MacTest();
		test.run(params);
		test.runRcaTest((MacTestParams) params);
	}
  
  private static void testAmrr(MacTestParams params) throws Exception {
    params.setAmrrParams();
    MacTest test = new MacTest();
    test.run(params);
    test.runRcaTest((MacTestParams) params);
  }
}
