package test.sim.scenario;

import jist.swans.Constants;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;
import brn.sim.builder.MetricBuilder;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RouteBuilder;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;
import brn.sim.scenario.txdor.TxDOrParams;
import brn.sim.scenario.txdor.TxDOrSim;

public class TestTxDOrSim {

  public static void main(String[] args) {
    TxDOrParams params =
      (TxDOrParams) TestParamBuilder.build(TxDOrParams.class);
    TxDOrSim test = new TxDOrSim();

    // set parameters
    params.endTime = 100;
    params.seed = 0;
    params.nodes = 16;

    params.seed = 2;

    DistShadowingParams pathLoss = new DistShadowingParams();
    pathLoss.exponent = 2.7;
    pathLoss.stdDeviation = 4.;
//    pathLoss.coherenceTime = 0 * Constants.SECOND;

    FieldBuilder.FieldParams field = new FieldBuilder.FieldParams();
    field.fieldX = 400;
    field.fieldY = 101;
    field.pathloss = pathLoss;
    field.spatial_mode = Constants.SPATIAL_LINEAR;
    params.field = field;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveTxDivParams();
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
    radio.placement = Constants.PLACEMENT_GRID;
    radio.placementOpts = "4x4";
    radio.useAnnos = true;
    params.node.radio = radio;

    MacBuilder.M802_11Params mac = new MacBuilder.M802_11TxDivParams();
    mac.useAnnos = radio.useAnnos;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    NetBuilder.IpParams net = new NetBuilder.TxDORParams();
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE, Constants.NET_PROTOCOL_MCEXOR,
        Constants.NET_PROTOCOL_FLOODING };
    params.node.net = net;

    RouteBuilder.BrnDsrParams route = new RouteBuilder.BrnDsrParams();
    route.protocol = Constants.NET_PROTOCOL_MCEXOR;
    route.forwarding = brn.swans.Constants.FORWARDING_TXDOR;
    route.discovery = brn.swans.Constants.DISCOVERY_PROACTIVE;
    route.floodintOffset = 50000;
    route.floodingPeriod = 10000;
    route.floodingMax = 0;
    params.node.route = route;

    MetricBuilder.EtxParams metric = new MetricBuilder.EtxParams();
    metric.period = 1000;
    metric.tau = 30000;
    metric.probes = new int[] {Constants.BANDWIDTH_1Mbps, 100};
    metric.numberOfChannels = field.channelNumber;
    metric.globalLinkTable = true;
    route.metric = metric;

    params.trafficParams.flowParams.start = 80000;
    ((FlowBuilder.SaturatingUdpParams)params.trafficParams.flowParams).end = 95000;

    try {
      test.run(params);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }

}
