package test.sim.scenario.mac;

import jist.runtime.JistAPI;
import jist.runtime.JistAPI.Continuation;
import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.net.NetAddress;
import jist.swans.net.NetInterface;
import jist.swans.net.NetMessage.Ip;

public interface NetIpMacTestInterface extends NetInterface
{
  public void run();

  public static final class Dlg implements NetIpMacTestInterface, JistAPI.Proxiable
  {
    private NetIpMacTestInterface netInterface;

    public Dlg(NetIpMacTestInterface netInterface)
    {
      this.netInterface = netInterface;
    }

    public void endSend(Message msg, int netid, MessageAnno anno)
    {
      netInterface.endSend(msg, netid, anno);
    }

    public NetAddress getAddress() throws Continuation
    {
      return netInterface.getAddress();
    }

    public void receive(Message msg, MacAddress lastHop, byte macId,
                        boolean promiscuous, MessageAnno anno)
    {
      netInterface.receive(msg, lastHop, macId, promiscuous, anno);
    }

    public void send(Ip msg, int interfaceId, MacAddress nextHop,
                     MessageAnno anno)
    {
      netInterface.send(msg, interfaceId, nextHop, anno);
    }

    public void send(Message msg, NetAddress dst, short protocol,
                     byte priority, byte ttl, MessageAnno anno)
    {
      netInterface.send(msg, dst, protocol, priority, ttl, anno);
    }

    public void run()
    {
      netInterface.run();
    }
  }

}