package test.sim.scenario.mac;

import test.sim.scenario.TestParamBuilder;
import jist.runtime.JistAPI;
import jist.swans.Constants;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.MacBuilder;
import brn.sim.builder.MetricBuilder;
import brn.sim.builder.NetBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RateBuilder;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;

public class TestMac802_11 {

  public static void main(String[] args) throws Exception {
    MacTestParams params = (MacTestParams) TestParamBuilder
        .build(MacTestParams.class);
    final MacTest test = new MacTest();

    /* gui on/off */
    params.gui = true;

    /* handler */
    params.handlerRadio = true;
    params.handlerMac = true;
    params.handlerNet = false;
    params.handlerRoute = false;
    params.handlerFlow = true;
    params.handlerForwardGraph = true;
    params.handlerLinkQuality = true;
    params.handlerLinkTable = true;
    params.handlerRadioTimeBar = true;
    params.handlerMacTimeBar = true;

    /* global */
    params.endTime = 20000;
    params.assertion = true;
    params.seed = 1;
    params.nodes = 4;

    params.singeSender = true;

    MetricBuilder.EtxParams metric = new MetricBuilder.EtxParams();
    metric.period = 1000;
    metric.tau = 30000 / 4;
    metric.probes = new int[] { Constants.BANDWIDTH_1Mbps, 1000,
        Constants.BANDWIDTH_2Mbps, 1000, Constants.BANDWIDTH_5_5Mbps, 1000,
        Constants.BANDWIDTH_11Mbps, 1000, };
    metric.numberOfChannels = Constants.CHANNEL_NUMBER_DEFAULT;
    params.metric = metric;

    DistShadowingParams pathLoss = new DistShadowingParams();
    pathLoss.exponent = 2.7;
    pathLoss.stdDeviation = 0.;
    pathLoss.coherenceTime = 0 * Constants.SECOND;

    FieldBuilder.FieldParams field = new FieldBuilder.FieldParams();
    field.fieldX = 97;
    field.fieldY = 1;
    field.spatial_mode = Constants.SPATIAL_LINEAR;
    field.pathloss = pathLoss;
    params.field = field;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveParams();
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
    radio.placement = Constants.PLACEMENT_GRID;
    radio.placementOpts = "4x1";
    radio.useAnnos = false;
    radio.radioType = Constants.MAC_802_11bg;
    params.node.radio = radio;

    MacBuilder.M802_11Params mac = new MacBuilder.M802_11Params();
//    mac.macType = (short) radio.radioType;
    if (radio.radioType == Constants.MAC_802_11a
        || radio.radioType == Constants.MAC_802_11g_PURE)
      params.bitrates = Constants.BITRATES_OFDM;
    else if (radio.radioType == Constants.MAC_802_11b
        || radio.radioType == Constants.MAC_802_11b_LONG)
      params.bitrates = Constants.BITRATES_DSSS;
    else if (radio.radioType == Constants.MAC_802_11bg)
      params.bitrates = Constants.BITRATES_ALL;
    else
      params.bitrates = Constants.BASIC_RATES_80211;
    RateBuilder.ConstantParams rate = new RateBuilder.ConstantParams();
    rate.setControlBitrate(params.bitrates[0]);
    rate.setDataBitrate(params.bitrates[0]);
    mac.rateSelection = rate;
    mac.useAnnos = radio.useAnnos;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    /**
     * MacTransmissionTimes parameters: longHeaders, minimalBasicRates,
     * shortDifs, threshold
     */
    boolean longHeaders = radio.radioType == Constants.MAC_802_11b_LONG;
    boolean minimalBasicRates = false;
    boolean shortDifs = radio.radioType == Constants.MAC_802_11a
        || radio.radioType == Constants.MAC_802_11g_PURE;
    params.txTimes = new MacTransmissionTimes(longHeaders, minimalBasicRates,
        shortDifs, Constants.MAC_THRESHOLD_RTS);

    NetBuilder.IpParams net = new NetBuilder.IpMacTestParams();
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_DUMB };
    params.node.net = net;

    params.node.route = null;

    /* Setup simulation */
    test.run(params);

    /* Show statistics at the end */
    JistAPI.runAt(new Runnable() {
      public void run() {
        try {
          test.showStatistics();
        } catch (Exception e) {
        }
      }
    }, JistAPI.END);

    /* Run the tests */
    test.runTxTimesTests((MacTestParams) params);
  }

}
