package test.util;

import jist.swans.field.Placement;
import org.apache.commons.math.random.RandomDataImpl;

import java.util.Vector;

public class PoissonPlacementTest {

  public static boolean test1() {

    Placement.Poisson pp = new Placement.Poisson(100, 100, 42, 50, 50, 10, 5);

    for (int i = 1; i < 10; i++) {
      System.out.println(pp.getNextLocation());
    }
    return true;
  }

  public static boolean test2() {

    float[] mx = {0.5f, 0.5f};
    float[] my = {0.5f, 0.5f};
    float[] lambda = {10, 20};
    float[] scaling = {10, 10};
    Placement.Poisson pp = new Placement.Poisson(1000, 1000, 101, mx, my, lambda, scaling);

    for (int i = 1; i < 10; i++) {
      System.out.println(pp.getNextLocation());
    }

    return true;
  }

  public static boolean test3() {
    float m = 10;
    int cnt = 101;
    RandomDataImpl rd = new RandomDataImpl();
    rd.reSeedSecure(101);

    Vector v1 = new Vector();
    for (int i = 0; i < cnt; i++) {
      v1.add(new Long(rd.nextPoisson(m)));
    }

    RandomDataImpl rd2 = new RandomDataImpl();
    rd2.reSeedSecure(101);

    Vector v2 = new Vector();
    for (int i = 0; i < cnt; i++) {
      v2.add(new Long(rd2.nextPoisson(m)));
    }

    if (v1.containsAll(v2) && v2.containsAll(v1))
      return true;
    else
      return false;
  }

  public static boolean test4() {
    float m = 10;
    int cnt = 6;
    RandomDataImpl rd = new RandomDataImpl();
    rd.reSeedSecure(101);
    rd.reSeed(101);

    for (int i = 0; i < cnt; i++) {
      System.out.println(rd.nextPoisson(m));
    }

    return true;
  }

  public static void main(String[] args) {
    //test2();
    boolean rv = test4();
    System.out.println(rv);
  }
}
