package jist.swans.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jist.swans.Node;
import jist.swans.misc.Event;
import jist.swans.misc.Location;
import jist.swans.radio.RadioInfo;

public abstract class AbstractField {

  // ////////////////////////////////////////////////
  // Events
  //

  public static class NodeMoveEvent extends Event {
    public RadioInfo info;
    public Location loc;
//    private Map mapRadioNode = new HashMap();

    /**
     * @deprecated use handle(int id, RadioInfo info, Location loc) 
     */
    public void handle(RadioInfo info, Location loc) {
//      Node node = (Node) mapRadioNode.get(info.getIdInteger());
//      if (null == node)
//        node = updateNodeMap(info);
//      this.nodeId = node.getNodeId();
      this.info = info;
      this.loc = loc;
      super.handle(info.getId());
    }

    /**
     * 
     * @param id ID of the node to be moved
     * @param info 
     * @param loc
     */
    public void handle(int id, RadioInfo info, Location loc) {
      this.info = info;
      this.loc = loc;
      super.handle(id);
    }
  }


  // ////////////////////////////////////////////////
  // locals
  //

  private Map nodes = new HashMap();

  protected NodeMoveEvent nodeMoveEvent = new NodeMoveEvent();


  // ////////////////////////////////////////////////
  // initialization
  //

  public AbstractField() {
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  public abstract FieldInterface getProxy();

  public Node getNode(int i) {
    return (Node)nodes.get(new Integer(i));
  }

  /**
   * Returns all nodes (sorted according to the nodeId)
   * @return all nodes (sorted according to the nodeId)
   */
  public List getNodes() {
    ArrayList sortedNodes = new ArrayList(nodes.values());
    Collections.sort(sortedNodes, new Comparator() {
      public int compare(Object arg0, Object arg1) {
        return ((Node)arg0).getNodeId() - ((Node)arg1).getNodeId();
      }
    });
    return sortedNodes;
  }

  public void addNode(Node node) {
    nodes.put(new Integer(node.getNodeId()), node);
  }
}
