package jist.swans.mac;

/**
 * Enumerator type for Java 1.4 compatibility. Used code from:
 * http://www.javaworld.com/javaworld/javatips/jw-javatip122.html.
 * 
 * @author ofriedri
 *
 */
public final class AckPolicy implements java.io.Serializable {
	
	/** For serializability */
	private static final long serialVersionUID = 1L;

	/** Directed frames with ack required */
	public static final AckPolicy NORMAL_ACK = new AckPolicy((short)1);
  /** Directed frames where sender doesn't require ack = new AckPolicy(true); and broadcast and multicast */
	public static final AckPolicy NO_ACK = new AckPolicy((short)2); 
  /** only used for QoS CF-Poll and QoS CF-Ack+CF-Poll */
	public static final AckPolicy NO_EXPLICIT_ACK = new AckPolicy((short)3); 
  /** recipent does not take action upon receipt = new AckPolicy(true); but expects BlockAckReq */
	public static final AckPolicy BLOCK_ACK = new AckPolicy((short)4);

	/** the internal value */
	private short m_value;

	public String toString() {
		return String.valueOf(m_value);
	}

	private AckPolicy(short value) {
		m_value = value;
	}

	private Object readResolve() throws java.io.ObjectStreamException {
		switch (m_value) {
			case 1: return NORMAL_ACK;
			case 2: return NO_ACK;
			case 3: return NO_EXPLICIT_ACK;
			case 4: return BLOCK_ACK;
			default: throw new IllegalArgumentException();
		}
	}

	/** For use in switch */
	public short val() {
		return m_value;
	}
} // end of class