//////////////////////////////////////////////////
// JIST (Java In Simulation Time) Project
// Timestamp: <MacMessage.java Sun 2005/03/13 11:06:45 barr rimbase.rimonbarr.com>
//

// Copyright (C) 2004 by Cornell University
// All rights reserved.
// Refer to LICENSE for terms and conditions of use.

package jist.swans.mac;

import java.util.List;

import jist.swans.misc.Message;

/**
 * Defines the various message used by the Mac entity.
 *
 * @author Rimon Barr &lt;barr+jist@cs.cornell.edu&gt;
 * @version $Id: MacMessage.java,v 1.17 2005/03/13 16:11:55 barr Exp $
 * @since SWANS1.0
 */

public interface MacMessage extends Message {

  int getId();

  public Object getAdapter(Class adapter);


  public abstract static class AbstractMacMessage implements MacMessage {

    /**
     * Unique id per packet, for viz purposes.
     */
    protected int messageId;

    /** used to derive message ids */
    protected static int messageIdBase = 0;


    public static Class classHasSeq = HasSeq.class;

    public static Class classHasSrc = HasSrc.class;

    public static Class classHasDst = HasDst.class;

    public static Class classHasCandidates = HasCandidates.class;

    public static Class classHasBody = HasBody.class;


    // ////////////////////////////////////////////////
    // initialization
    //

    protected AbstractMacMessage() {
      messageId = messageIdBase++;
    }

    // ////////////////////////////////////////////////
    // accessors
    //

    /*
     * (non-Javadoc)
     * @see jist.swans.mac.MacMessage#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class adapter) {
      return null;
    }

    public int getId() {
      return messageId;
    }

  }

  public static interface HasSeq extends MacMessage {
    short getSeq();
  }

  public static interface HasSrc extends MacMessage {
    MacAddress getSrc();
  }

  public static interface HasDst extends MacMessage {
    MacAddress getDst();
  }

  public interface HasCandidates extends MacMessage {
    List /* MacAddress */ getCandidates();
  }

  public interface HasBody extends MacMessage {
    Message getBody();
  }

} // class: MacMessage

