//////////////////////////////////////////////////
// JIST (Java In Simulation Time) Project
// Timestamp: <Protocol.java Tue 2004/04/06 11:46:47 barr pompom.cs.cornell.edu>
//

// Copyright (C) 2004 by Cornell University
// All rights reserved.
// Refer to LICENSE for terms and conditions of use.

package jist.swans.misc;

import jist.runtime.JistAPI;

/**
 * Network protocol interface.
 *
 * @author Rimon Barr &lt;barr+jist@cs.cornell.edu&gt;
 * @version $Id: Protocol.java,v 1.3 2004/04/06 16:07:49 barr Exp $
 * @since SWANS1.0
 */
public interface Protocol
{
  /**
   * Start running protocol.
   */
  void start();


  public static final class Dlg implements JistAPI.Proxiable, Protocol {
    private Protocol dlg;

    public Dlg(Protocol dlg) {
      super();
      this.dlg = dlg;
    }

    public void start() {
      dlg.start();
    }
  }
} // interface: Protocol

