/**
 *
 */
package jist.swans.rate;

import jist.swans.Constants;
import jist.swans.mac.MacAddress;
import jist.swans.mac.MacInfo;
import jist.swans.phy.PhyMessage;

/**
 * @author Oliver
 *
 */
public abstract class AbstractRca implements RateControlAlgorithmIF
{
  // Local reference to containing MAC instance
  protected /*final*/ MacInfo m_macInfo;

  public static GlobalMacRateInfo s_macRateInfo = GlobalMacRateInfo.INSTANCE;
  
  /**
   * The data rate of the last packet received by the MAC (control or data).
   * This information is not needed per communication partner, since there is
   * always only one packet exchange at a time, anyways.
   * 
   * Used to calculate the control rate.
   */
  protected int m_lastDataRate = Constants.BANDWIDTH_INVALID;

  /**
   * 
   */
  public AbstractRca(MacInfo macInfo)
  {
    m_macInfo = macInfo;
  }

  /*
   * (non-Javadoc)
   *
   * @see jist.swans.rate.RateControlAlgorithmIF#reportPacketRx(PhyMessage)
   */
  public void reportPacketRx(PhyMessage msg) {
		m_lastDataRate = msg.getPayloadRate();
	}

	
  /*
   * (non-Javadoc)
   *
   * @see jist.swans.rate.RateControlAlgorithmIF#getRetryLimit(int)
   */
  public byte getRetryLimit(MacAddress nextHop, int packetLength)
  {
    return packetLength <= m_macInfo.getThresholdRts() ?
        m_macInfo.getRetryLimitShort() : m_macInfo.getRetryLimitLong();
  }
}
