/*-
 * Copyright (c) 2004 INRIA
 * Copyright (c) 2002-2005 Sam Leffler, Errno Consulting
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    similar to the "NO WARRANTY" disclaimer below ("Disclaimer") and any
 *    redistribution must be conditioned upon including a substantially
 *    similar Disclaimer requirement for further binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 *
 * $Id: amrr.h 2394 2007-05-30 01:41:18Z mtaylor $
 */
/**
 * 
 */
package jist.swans.rate;

import jist.swans.Constants;

/**
 * @author ofriedri
 */
public class AmrrState {
  public static final int size = 4;

  /* AMRR statistics for this node */
  public int[] txTriesCnt;

  public int txFailureCnt;

  /* AMRR algorithm state for this node */
  public int minSuccessThreshold;

  public int successThreshold;

  public int success;

  public boolean recovery;

  /* rate index et al. */
  public int[] txRates;

  public int[] txTries;

  public AmrrState(int minSuccessThreshold) {
    this.minSuccessThreshold = minSuccessThreshold;
    txRates = new int[size];
    txTries = new int[size];
    txTriesCnt = new int[size];
    reset();
  }

  private void reset() {
    for (int i = 0; i < txTriesCnt.length; i++)
      txTriesCnt[i] = 0;
    txFailureCnt = 0;
    success = 0;
    recovery = false;
    successThreshold = minSuccessThreshold;
  }

  public boolean isSuccess() {
    return txTriesCnt[1] </*=*/ (txTriesCnt[0] / 10);
  }

  public boolean isEnough() {
    return txTriesCnt[0] > 10;
  }

  public boolean isFailure() {
    return txTriesCnt[1] > (txTriesCnt[0] / 3);
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < size; i++)
      sb.append(" cnt").append(i).append(":").append(txTriesCnt[i]);
    sb.append(" -- threshold: ").append(successThreshold);
    sb.append(" -- now:");
    for (int i = 0; i < size; i++)
      sb.append(" r").append(i).append(":").append(
          txRates[i] / Constants.BANDWIDTH_1Mbps);
    return sb.toString();
  }
}
