package jist.swans.rate;

import org.apache.log4j.Logger;

import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.phy.PhyMessage;

/**
 * Uses bit-rate annotations, if any. Otherwise it delegates to the chained
 * selection instance.
 *
 * TODO implement
 *
 * @author kurth
 */
public class AnnoRate implements RateControlAlgorithmIF {

  /** SampleRate logger. */
  public static final Logger log = Logger.getLogger(AnnoRate.class);

  /** next selector in chain */
  private RateControlAlgorithmIF next;

  /**
   * @param next bitrate selector to use if no annos are found
   */
  public AnnoRate(RateControlAlgorithmIF next) {
    this.next = next;
  }

  /**
   * @see jist.swans.rate.RateControlAlgorithmIF#getControlRate(jist.swans.mac.MacAddress, int)
   */
  public int getControlRate(MacAddress nextHop, int dataRate) {
    return next.getControlRate(nextHop, dataRate);
  }

  /**
   * @see jist.swans.rate.RateControlAlgorithmIF#getNextDataRate(Message, MessageAnno, Object, int, int)
   */
  public int getNextDataRate(Message packet, MessageAnno anno, Object nextHop, int frameLen, int triesBefore) {
    Integer dataRateObj = null == anno ? null :
      (Integer) anno.get(MessageAnno.ANNO_MAC_BITRATE);
    if (null != dataRateObj) {
      // TODO use control rate for message type rts, cts, ack
      return dataRateObj.intValue();
    }
    if (log.isDebugEnabled())
      log.debug("(getDataRate) DEFER to " + next.getClass());
    return next.getNextDataRate(packet, anno, (MacAddress)nextHop, frameLen, triesBefore);
  }

  /**
   * @see jist.swans.rate.RateControlAlgorithmIF#reportPacketRx(jist.swans.phy.PhyMessage)
   */
  public void reportPacketRx(PhyMessage msg) {
    next.reportPacketRx(msg);
  }

  /**
   * @see jist.swans.rate.RateControlAlgorithmIF#reportPacketRx(PhyMessage)
   */
  public void reportPacketTx(MacAddress nextHop, int type, int size, int bitrate, int shortTries, int longTries, int status) {
    next.reportPacketTx(nextHop, type, size, bitrate, shortTries, longTries, status);
  }

}
