package jist.swans.rate;

import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.misc.MessageAnno;
import jist.swans.phy.PhyMessage;

/**
 * ConstantRate does only one thing right now: It return the same
 * bit-rate (as dataRate and controlRate) at any given time.
 *
 * @author Oliver
 *
 */
public class ConstantRate extends AbstractRca
    implements RateControlAlgorithmIF {

  private int dataBitrate;

  private int controlBitrate;

  /**
   * Constructor
   *
   * @param dataBitrate
   *          The data bit-rate that this algorithm will always return.
   * @param controlBitrate
   *          The control bit-rate that this algorithm will always return.
   */
  public ConstantRate(int dataBitrate, int controlBitrate) {
    super(null);
    this.dataBitrate = dataBitrate;
    this.controlBitrate = controlBitrate;
  }

  public ConstantRate(int dataBitrate) {
    this(dataBitrate, dataBitrate);
  }

  /**
   * @return the controlBitrate
   */
  public int getControlBitrate() {
    return controlBitrate;
  }

  public int getDataBitrate() {
    return dataBitrate;
  }

  /* (non-Javadoc)
   * @see jist.swans.rate.RateControlAlgorithmIF#getNextDataRate(jist.swans.mac.MacAddress, int, int)
   */
  public int getNextDataRate(Message packet, MessageAnno anno, Object dest, int frameLen, int triesBefore) {
    // always return the same bitrate
    return this.dataBitrate;
  }

  /* (non-Javadoc)
   * @see jist.swans.rate.RateControlAlgorithmIF#getControlRate(jist.swans.mac.MacAddress, int)
   */
  public int getControlRate(MacAddress dest, int dataRate) {
    return this.controlBitrate;
  }

  /* (non-Javadoc)
   * @see jist.swans.rate.RateControlAlgorithmIF#reportPacketRx(jist.swans.phy.PhyMessage)
   */
  public void reportPacketRx(PhyMessage msg) {
    // do nothing
  }

  /* (non-Javadoc)
   * @see jist.swans.rate.RateControlAlgorithmIF#reportPacketTx(jist.swans.mac.MacAddress, int, int, int, int, int, int)
   */
  public void reportPacketTx(MacAddress nextHop, int type, int size, int bitrate, int shortTries, int longTries, int status) {
    // do nothing
  }

}
